'use strict';

/* --------------------------------------------------------------
 product_question.js 2016-11-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Widget that updates that opens a lightbox for asking product questions. Sends an e-mail to the shop administrator
 * with the asked question
 */
gambio.widgets.module('product_question', ['xhr', gambio.source + '/libs/modal.ext-magnific', gambio.source + '/libs/modal'], function (data) {

    'use strict';

    // ########## VARIABLE INITIALIZATION ##########

    var $this = $(this),
        $body = $('body'),
        defaults = {
        btnOpen: '.btn-product-question',
        btnClose: '.btn-close-question-window',
        btnSend: '.btn-send-question',
        url: 'shop.php?do=ProductQuestion',
        sendUrl: 'shop.php?do=ProductQuestion/Send',
        productId: 0,
        formSelector: '#product-question-form',
        productFormSelector: '.js-product-form'
    },
        options = $.extend(true, {}, defaults, data),
        module = {};

    // ########## EVENT HANDLER ##########

    var _validateForm = function _validateForm() {
        try {
            var $privacyCheckbox = $('#privacy_accepted'),
                error = false;

            $this.find('.form-group.mandatory, .checkbox-inline').removeClass('has-error');

            // Validate required fields. 
            $this.find('.form-group.mandatory').each(function () {
                var $formControl = $(this).find('.form-control');

                if ($formControl.val() === '') {
                    $(this).addClass('has-error');
                    error = true;
                }
            });

            if ($privacyCheckbox.length && !$privacyCheckbox.prop('checked')) {
                $privacyCheckbox.closest('.checkbox-inline').addClass('has-error');
                error = true;
            }

            if (error) {
                throw new Error();
            }

            return true;
        } catch (exception) {
            return false;
        }
    };

    var _openModal = function _openModal(e) {
        e.preventDefault();
        var formData = $(options.productFormSelector).serialize();

        jse.libs.xhr.get({ url: options.url + '&' + formData + '&productId=' + options.productId }, true).done(function (response) {
            _closeModal();
            $body.append(response.content);
            gambio.widgets.init($('.mfp-wrap'));
            _activateGoogleRecaptcha();
        });
    };

    var _closeModal = function _closeModal() {
        $('.mfp-bg, .mfp-wrap').remove();
        $(options.btnSend).off('click', _sendForm);
        $(options.btnClose).off('click', _closeModal);
    };

    var _sendForm = function _sendForm() {
        if (!_validateForm()) {
            return;
        }

        var formData = $(options.productFormSelector).serialize();
        var url = options.sendUrl + '&' + formData + '&productId=' + options.productId,
            data = $(options.formSelector).serialize() + '&productLink=' + location.href;

        $.ajax({
            url: url,
            data: data,
            type: 'POST',
            dataType: 'json'
        }).done(function (response) {
            _closeModal();
            $body.append(response.content);
            gambio.widgets.init($('.mfp-wrap'));

            if (!response.success) {
                _activateGoogleRecaptcha();
            }
        });
    };

    var _activateGoogleRecaptcha = function _activateGoogleRecaptcha() {
        if (typeof window.showRecaptcha === 'function') {
            setTimeout(function () {
                window.showRecaptcha('captcha_wrapper');
            }, 500);
        }
    };

    // ########## INITIALIZATION ##########

    /**
     * Init function of the widget
     */
    module.init = function (done) {
        if (options.modalMode === undefined) {
            $(options.btnOpen).on('click', _openModal);
        }
        $(options.btnSend).on('click', _sendForm);
        $(options.btnClose).on('click', _closeModal);

        done();
    };

    // Return data to widget engine
    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
